package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;

@Repository
public interface UserProfileDeactivationReasonRepository extends JpaRepository<UserProfileDeactivationReason, Long> {
	
	@Query("select u from UserProfileDeactivationReason u where lower(u.name) = lower(:name)")
	UserProfileDeactivationReason findUserProfileDeactivationReasonByName(@Param("name") String name);

	@Query("select u from UserProfileDeactivationReason u")
	List<UserProfileDeactivationReason> findAllUserProfileDeactivationReasons();
}
